/*
 * Decompiled with CFR 0.152.
 */
package com.dreamfabric.jsidplay;

import com.dreamfabric.jac64.VICConstants;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;

public class C64TextRenderer {
    private int[] memory;
    private int[] mem;
    private MemoryImageSource mis;
    private Image screen;
    private int width;
    private int height;
    private int[] COLOR_SET = VICConstants.COLOR_SETS[2];
    private int[] color = new int[]{this.COLOR_SET[6], this.COLOR_SET[14]};

    public C64TextRenderer(int[] memory, int width, int height) {
        this.memory = memory;
        this.mem = new int[(width *= 8) * height];
        this.mis = new MemoryImageSource(width, height, this.mem, 0, width);
        this.mis.setAnimated(true);
        this.mis.setFullBufferUpdates(true);
        this.screen = Toolkit.getDefaultToolkit().createImage(this.mis);
        this.width = width;
        this.height = height;
    }

    public void setColor(int cnum, int colorVal) {
        this.color[cnum] = colorVal;
    }

    public void setCBMColor(int cnum, int cval) {
        this.color[cnum] = this.COLOR_SET[cval & 0xF];
    }

    public Image getImage() {
        return this.screen;
    }

    public void renderText(String text) {
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char c = text.charAt(i);
            if (Character.isLetter(c)) {
                c = (char)(c - 97 + 1);
            }
            c = (char)(c & 0xFF);
            int pos = 118784 + c * 8;
            int x = i * 8;
            int m = 8;
            for (int j = 0; j < m; ++j) {
                int d = this.memory[pos + j];
                int mpos = x + j * this.width;
                this.renderByte(mpos, d);
            }
        }
        this.mis.newPixels();
    }

    private void renderByte(int mpos, int data) {
        int n = 0;
        for (int i = 7; i >= n; --i) {
            this.mem[mpos++] = this.color[data >> i & 1];
        }
    }
}

